<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certification - CERT-DgA2uu6Z</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Times+New+Roman&family=Dancing+Script:wght@700&display=swap');

        @page {
            size: A4;
            margin: 0;
        }
        body {
            font-family: 'Times New Roman', serif;
            background: linear-gradient(135deg, #E6F0FA, #D1C4E9);
            margin: 0;
            padding: 0;
            height: 297mm;
            width: 210mm;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
        }
        .certificate {
            background: url('https://via.placeholder.com/190mmx250mm?text=Certificate+Background+with+Courses+Pattern') no-repeat center, linear-gradient(to bottom right, #F5F5F5, #E0E0E0);
            background-size: cover;
            width: 190mm;
            height: 250mm; /* Reduced from 277mm */
            border: 4mm solid #2196F3;
            border-radius: 5mm;
            box-shadow: 0 2mm 6mm rgba(0, 0, 0, 0.15);
            padding: 15mm;
            position: relative;
            text-align: center;
            color: #333;
        }
        .certificate::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://via.placeholder.com/30mm?text=Logo') no-repeat top 10mm left 10mm;
            opacity: 0.1;
            z-index: 0;
        }
        .header {
            font-family: 'Dancing Script', cursive;
            font-size: 8mm;
            color: #1A237E;
            margin-bottom: 4mm;
            letter-spacing: 0.4mm;
            text-shadow: 0.3mm 0.3mm 1mm rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .header .serial {
            font-size: 4mm;
            color: #555;
            font-weight: 500;
            background: rgba(255, 255, 255, 0.9);
            padding: 2mm 4mm;
            border-radius: 2mm;
            margin-top: 2mm;
        }
        .subheader {
            font-family: 'Times New Roman', serif;
            font-size: 5mm;
            color: #2196F3;
            margin-bottom: 8mm;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.2mm;
            position: relative;
            z-index: 1;
        }
        .recipient {
            font-size: 7mm;
            font-weight: bold;
            color: #1A237E;
            margin-bottom: 5mm;
            padding: 3mm 6mm;
            background: rgba(33, 150, 243, 0.1);
            border-radius: 3mm;
            display: inline-block;
            box-shadow: 0 1mm 2mm rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
        }
        .course-title {
            font-size: 6mm;
            color: #2196F3;
            margin-bottom: 6mm;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.2mm;
            position: relative;
            z-index: 1;
        }
        .details {
            font-size: 4.5mm;
            color: #555;
            margin-bottom: 6mm;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(40mm, 1fr));
            gap: 5mm;
            background: rgba(26, 35, 126, 0.05);
            padding: 6mm;
            border-radius: 3mm;
            position: relative;
            z-index: 1;
        }
        .details div {
            margin: 2mm 0;
        }
        .signature {
            position: absolute;
            bottom: 15mm;
            right: 15mm;
            font-size: 4.5mm;
            color: #1A237E;
            font-weight: bold;
            text-align: left;
            z-index: 1;
        }
        .signature img {
            margin-top: 3mm;
            width: 45mm;
            border-bottom: 0.3mm solid #2196F3;
        }
    </style>
</head>
<body>
    <div class="certificate">
        <div class="header">
            Certificate of Achievement
            <div class="serial">Serial Number: CERT-DgA2uu6Z</div>
        </div>
        <div class="subheader">CloudAxis Technologies E-Learning Excellence</div>
        <div class="recipient">
            This Certifies That {{ $fullName ?? 'Safu Khan' }}
        </div>
        <div class="course-title">Has Successfully Completed the Course "{{ $courseName ?? 'Introduction to Python' }}"</div>
        <div class="details">
            <div>Issue Date: {{ $certification->Issue_date ? $certification->Issue_date->format('d M Y') : '06 Sep 2025' }}</div>
            <div>Expiry Date: {{ $certification->Expiry_date ? $certification->Expiry_date->format('d M Y') : '06 Sep 2026' }}</div>
        </div>
        <div class="signature">
            Authorized Signature<br>
            <img src="https://via.placeholder.com/45mmx18mm?text=Signature" alt="Signature">
        </div>
    </div>
</body>
</html>
